/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.base.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import svenhjol.charm.Charm;
import svenhjol.charm.base.CharmLoader;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.BiomeHandler;
import svenhjol.charm.base.handler.ConfigHandler;
import svenhjol.charm.base.handler.DecorationHandler;
import svenhjol.charm.base.helper.StringHelper;
import svenhjol.charm.base.loader.condition.ModuleEnabledCondition;
import svenhjol.charm.module.Quark;

public class ModuleHandler {
    private static final Map<String, ModContainer> FORGE_MOD_CONTAINERS = new ConcurrentHashMap<String, ModContainer>();
    private static List<Class<? extends CharmModule>> ENABLED_MODULES = new ArrayList<Class<? extends CharmModule>>();
    public static ConfigHandler CONFIG_HANDLER;
    public static Map<String, CharmModule> LOADED_MODULES;
    public static final Map<String, CharmLoader> LOADER_INSTANCES;
    public static final IEventBus FORGE_EVENT_BUS;
    public static ModuleHandler INSTANCE;

    public ModuleHandler() {
        FORGE_EVENT_BUS.addListener(this::onServerAboutToStart);
        CONFIG_HANDLER = new ConfigHandler();
        BiomeHandler.init();
        CraftingHelper.register((IConditionSerializer)new ModuleEnabledCondition.Serializer());
    }

    public void addLoader(CharmLoader loader) {
        String modId = loader.getModId();
        IEventBus MOD_EVENT_BUS = FMLJavaModLoadingContext.get().getModEventBus();
        LOADER_INSTANCES.put(modId, loader);
        MOD_EVENT_BUS.addListener(this::onCommonSetup);
        MOD_EVENT_BUS.addListener(this::onModConfig);
        MOD_EVENT_BUS.addListener(loader::onCommonSetup);
        MOD_EVENT_BUS.addListener(loader::onModConfig);
        FORGE_EVENT_BUS.addListener(loader::onServerStarting);
        Charm.LOG.info("Subscribed '" + modId + "' to Forge event bus");
    }

    @Nullable
    public CharmLoader getLoader(String modId) {
        return LOADER_INSTANCES.getOrDefault(modId, null);
    }

    public void register(CharmModule module) {
        LOADED_MODULES.put(module.getName(), module);
        Charm.LOG.debug("Registering module " + module.getName());
        module.register();
    }

    public void depends(CharmModule module) {
        String name = module.getName();
        boolean isEnabled = module.enabled;
        boolean dependencyCheck = module.depends();
        String message = !isEnabled ? "Module " + name + " is not enabled." : (!dependencyCheck ? "Module " + name + " did not pass dependency check, disabling." : "Module " + name + " is enabled.");
        Charm.LOG.debug("[ModuleHandler] " + message);
        module.enabled = isEnabled && dependencyCheck;
    }

    public void init(CharmModule module) {
        ENABLED_MODULES.add(module.getClass());
        if (module.hasSubscriptions) {
            FORGE_EVENT_BUS.register((Object)module);
        }
        Charm.LOG.info("Initialising module " + module.getName());
        module.init();
    }

    public void onModConfig(ModConfig.ModConfigEvent event) {
        ConfigHandler.refreshAllConfig();
    }

    public void onCommonSetup(FMLCommonSetupEvent event) {
    }

    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        DecorationHandler.init();
    }

    @Nullable
    public static CharmModule getModule(String moduleName) {
        return LOADED_MODULES.getOrDefault(StringHelper.snakeToUpperCamel(moduleName), null);
    }

    public static Map<String, CharmModule> getLoadedModules() {
        return LOADED_MODULES;
    }

    public static boolean enabled(Class<? extends CharmModule> clazz) {
        return ENABLED_MODULES.contains(clazz);
    }

    public static boolean enabled(String moduleName) {
        String[] split = moduleName.split(":");
        String modName = split[0];
        String modModule = split[1];
        switch (modName) {
            case "charm": {
                CharmModule module = ModuleHandler.getModule(modModule);
                return module != null && module.enabled;
            }
            case "quark": {
                return Quark.compat.isModuleEnabled(modModule);
            }
        }
        return false;
    }

    static {
        LOADED_MODULES = new ConcurrentHashMap<String, CharmModule>();
        LOADER_INSTANCES = new HashMap<String, CharmLoader>();
        FORGE_EVENT_BUS = MinecraftForge.EVENT_BUS;
        INSTANCE = new ModuleHandler();
    }
}

